using UnityEngine;
using UnityEditor;

[CustomEditor(typeof(AStarPathfinderTest))]
public class AStarPathfinderTestEditor : Editor
{
    public override void OnInspectorGUI()
    {
        // 绘制默认Inspector
        DrawDefaultInspector();

        AStarPathfinderTest pathfinderTest = (AStarPathfinderTest)target;

        EditorGUILayout.Space(10);
        EditorGUILayout.LabelField("操作", EditorStyles.boldLabel);

        // 初始化按钮
        GUI.enabled = !pathfinderTest.IsInitialized || !Application.isPlaying;
        if (GUILayout.Button("初始化寻路器", GUILayout.Height(30)))
        {
            pathfinderTest.InitializePathfinder();
        }
        GUI.enabled = true;

        EditorGUILayout.Space(5);

        // 寻路按钮
        GUI.backgroundColor = new Color(0.4f, 0.8f, 0.4f);
        if (GUILayout.Button("执行寻路", GUILayout.Height(40)))
        {
            pathfinderTest.ExecuteFindPath();
            SceneView.RepaintAll();
        }
        GUI.backgroundColor = Color.white;

        EditorGUILayout.Space(5);

        // 清除路径按钮
        GUI.backgroundColor = new Color(0.8f, 0.4f, 0.4f);
        if (GUILayout.Button("清除路径", GUILayout.Height(25)))
        {
            pathfinderTest.ClearPath();
            SceneView.RepaintAll();
        }
        GUI.backgroundColor = Color.white;

        EditorGUILayout.Space(10);

        // 状态显示
        EditorGUILayout.LabelField("状态", EditorStyles.boldLabel);
        EditorGUILayout.HelpBox(
            pathfinderTest.IsInitialized ? "✓ 寻路器已初始化" : "✗ 寻路器未初始化（点击运行或初始化按钮）",
            pathfinderTest.IsInitialized ? MessageType.Info : MessageType.Warning
        );

        // 如果有路径结果，显示额外信息
        if (pathfinderTest.PathLength > 0)
        {
            EditorGUILayout.Space(5);
            EditorGUILayout.BeginVertical(EditorStyles.helpBox);
            EditorGUILayout.LabelField($"探索节点数: {pathfinderTest.NodesExplored}");
            EditorGUILayout.LabelField($"搜索耗时: {pathfinderTest.SearchTimeMs:F3} ms");
            EditorGUILayout.LabelField($"路径点数: {pathfinderTest.PathLength}");
            EditorGUILayout.EndVertical();
        }
    }
}

