﻿using UnityEditor;
using UnityEngine;

[CustomEditor(typeof(CreatOctreeTree))]
public class CreatOctreeTreeEditor : Editor
{
    public override void OnInspectorGUI()
    {
        DrawDefaultInspector();

        CreatOctreeTree script = (CreatOctreeTree)target;

        EditorGUILayout.Space(10);

        EditorGUILayout.BeginHorizontal();
        if (GUILayout.Button("清除构建"))
        {
            script.ClearOctree();
        }
        if (GUILayout.Button("重新构建"))
        {
            script.RebuildOctree();
        }
        EditorGUILayout.EndHorizontal();
    }
}
